/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing.modules;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import java.io.*;
import lindhorst.apps.jdbc.swing.modules.datamodels.*;
import lindhorst.apps.jdbc.swing.helpers.*;
import lindhorst.apps.jdbc.swing.*;

public class QueryMaker extends JInternalFrame implements ChangeListener, ListSelectionListener, ActionListener, Module
{
  private JTextArea input=new JTextArea(3,0);
  private JTable table=new JTable(1,1);
  private JPanel out=new JPanel(new BorderLayout(0,0));;
  private JTextArea errors=new JTextArea();
  private QueriesDataModel model=null;
  private JList list=new JList();

  public QueryMaker(QueriesDataModel model)
  {
    super(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("queries"),true,true,true,true);
    setFrameIcon(Helpers.getIcon(getClass(),"queries.gif"));
    setOpaque(false);
    this.model=model;
    model.addChangeListener(this);

    init();
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    setVisible(true);
    validate();
  }

  public QueryMaker(Connection readableConnection,Connection writableConnection)
  {
    this(new QueriesDataModel(readableConnection,writableConnection));
  }

  public void init()
  {
    out.setBorder(BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("db_output")));
    table.setModel(model.getTableModelFromOutput());
    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    JScrollPane tableView=new JScrollPane(table);
    tableView.setPreferredSize(new Dimension(400,350));
    out.add(tableView,BorderLayout.CENTER);
    JSplitPane pane=new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,false);
    pane.setOneTouchExpandable(true);
    pane.add(out);

    Box box2=Box.createVerticalBox();

    JPanel err=new JPanel(new BorderLayout());
    err.setBorder(BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("sql_errors")));
    errors.setLineWrap(true);
    errors.setWrapStyleWord(true);
    JScrollPane errView=new JScrollPane(errors,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    errView.setPreferredSize(new Dimension(100,200));
    errors.setEditable(false);
    err.add(errView,BorderLayout.CENTER);
    box2.add(err);

    box2.add(Box.createVerticalStrut(10));

    JPanel old=new JPanel(new BorderLayout());
    old.setBorder(BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("previous_commands")));
    JScrollPane listView=new JScrollPane(list);
    listView.setPreferredSize(new Dimension(100,100));
    list.setListData(model.getOldCommands());
    list.addListSelectionListener(this);
    old.add(listView,BorderLayout.CENTER);
    box2.add(old);

    pane.add(box2);

    pane.resetToPreferredSizes();


    JPanel command=new JPanel(new BorderLayout());
    command.setBorder(BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("sql_command")));
    input.setLineWrap(true);
    command.add(new JScrollPane(input),BorderLayout.CENTER);

    JPanel buttonsSurroundings=new JPanel();
    buttonsSurroundings.setBorder(BorderFactory.createEmptyBorder(1,10,1,10));
    buttonsSurroundings.setLayout(new GridLayout(3,1,5,5));

    JButton button=new JButton(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("ok"));
    button.setMnemonic('O');
    button.setToolTipText(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("exec.tooltip"));
    button.addActionListener(this);
    buttonsSurroundings.add(button,
      new GridBagConstraints(
        GridBagConstraints.RELATIVE,GridBagConstraints.RELATIVE,
        GridBagConstraints.REMAINDER,1,0.0,0.0,
        GridBagConstraints.CENTER,GridBagConstraints.HORIZONTAL,
        new Insets(2,2,2,2),1,1));
    button=new JButton(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save"));
    button.setMnemonic('S');
    button.setToolTipText(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save.tooltip"));
    button.addActionListener(this);
    buttonsSurroundings.add(button,
      new GridBagConstraints(
        GridBagConstraints.RELATIVE,GridBagConstraints.RELATIVE,
        GridBagConstraints.REMAINDER,1,0.0,0.0,
        GridBagConstraints.CENTER,GridBagConstraints.HORIZONTAL,
        new Insets(2,2,2,2),1,1));
    button=new JButton(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("delete"));
    button.setMnemonic('L');
    button.setToolTipText(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("delete.tooltip"));
    button.addActionListener(this);
    buttonsSurroundings.add(button,
      new GridBagConstraints(
        GridBagConstraints.RELATIVE,GridBagConstraints.RELATIVE,
        GridBagConstraints.REMAINDER,1,0.0,0.0,
        GridBagConstraints.CENTER,GridBagConstraints.HORIZONTAL,
        new Insets(2,2,2,2),1,1));
    command.add(buttonsSurroundings,BorderLayout.EAST);


    JPanel c=new JPanel(new BorderLayout(5,5));
    c.setLayout(new BorderLayout(10,10));
    c.add(pane, BorderLayout.CENTER);
    c.add(command,BorderLayout.SOUTH);

    setContentPane(c);

  }

  public QueriesDataModel getModel()
  {
    return model;
  }

  public void setModel(QueriesDataModel model)
  {
    this.model=model;
    model.addChangeListener(this);
  }

  public void stateChanged(ChangeEvent event)
  {
    if(model.isExecuting())
      Helpers.setCursor(this,Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    //Textfelder fllen
    String warnings=model.getWarnings();
    errors.setText(warnings!=null?warnings:"");
    //Alte Kommandos holen
    list.setListData(model.getOldCommands());
    list.ensureIndexIsVisible(list.getModel().getSize());
    //Tabelle initialisieren
    table.setModel(model.getTableModelFromOutput());
    table.validate();
    if(!model.isExecuting()) Helpers.setCursor(this,Cursor.getDefaultCursor());
  }

  public void valueChanged(ListSelectionEvent event)
  {
    input.setText((String)list.getSelectedValue());
  }

  public void actionPerformed(ActionEvent ae)
  {
    if(ae.getActionCommand().equalsIgnoreCase(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save")))
    {
      save();
      return;
    }
    else if (ae.getActionCommand().equalsIgnoreCase(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("delete")))
    {
      input.setText("");
      return;
    }
    else
    {
      String sql=input.getText().replace('\r',' ');
      sql=sql.replace('\n',' ');
      input.setText("");
      model.executeSQL(sql);
      return;
    }
  }

  public void save()
  {
    String command=input.getText();
    if(command==null || command.equals(""))
    {
      JOptionPane.showMessageDialog(Helpers.getTopLevelContainer(),java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("no_sql_command"),java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("no_command"),JOptionPane.ERROR_MESSAGE);
      return;
    }

    Object[] names=extractQueryNames();
    boolean doAgain=true;
    String name,description;

    //get Name from user
    do
    {
      name=JOptionPane.showInputDialog(Helpers.getTopLevelContainer(),java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("name_entry"),java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save_as"),JOptionPane.QUESTION_MESSAGE);
      if(name==null) return;  //aborted
      if(name.equals(""))
        continue;   //no name given
      if(name.indexOf(' ')>=0)
        continue;

      //so far alright, don't do it again
      doAgain=false;

      for(int i=0;i<names.length;i++)
      {
        if(((String)names[i]).equals(name))
        {
          doAgain=true;
          break;
        }
      }

      if(doAgain)
      {
        int retValue=JOptionPane.showConfirmDialog(Helpers.getTopLevelContainer(),name+java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("already_exists"),java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("overwrite"),JOptionPane.YES_NO_OPTION,JOptionPane.WARNING_MESSAGE);
        if(retValue==0) doAgain=false;
      }
    } while(doAgain);

    //get description from user
    description=JOptionPane.showInputDialog(Helpers.getTopLevelContainer(),java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("description"),java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("save_as"),JOptionPane.QUESTION_MESSAGE);
    if(description==null) return; //canceled

    //Test: do we already have that query?
    boolean alreadyThere=false;
    for(int i=0;i<names.length;i++)
    {
      if(((String)names[i]).equals(name))
      {
        alreadyThere=true;
        break;
      }
    }

    Properties props=((AppPane)getParent()).getModel().getProperties();

    //if no: save a new index!
    if(!alreadyThere)
      props.put("jdbcsession."+QUERY+"."+names.length+".name",name);

    //save command and description
    props.put("jdbcsession."+QUERY+"."+name+".command",command);
    props.put("jdbcsession."+QUERY+"."+name+".description",description);

    //save props
    try
    {
      ((AppPane)getParent()).getModel().save();
    }
    catch(Exception exc)
    {
      Helpers.showError(exc);
    }
  }

  private Object[] extractQueryNames()
  {
    ArrayList array=new ArrayList(20);
    Properties props=((AppPane)getParent()).getModel().getProperties();
    int index=0;
    String name;

    while((name=props.getProperty("jdbcsession."+QUERY+"."+index+".name"))!=null)
    {
      array.add(name);
      index++;
    }

    return array.toArray();
  }
}

