/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing.modules;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import java.io.*;
import lindhorst.apps.jdbc.swing.modules.datamodels.*;
import lindhorst.apps.jdbc.swing.helpers.*;
import lindhorst.apps.jdbc.swing.*;

public class SingleRecordEditor extends JDialog implements ActionListener
{
  private boolean properlyClosed=false;
  private SingleRecordDataModel model=null;

  public SingleRecordEditor(String[] columnHeaders)
  {
    this(columnHeaders,null);
  }

  public SingleRecordEditor(String[] columnHeaders, Class[] columnClasses)
  {
    super(Helpers.getTopLevelContainer(),java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("new_record"),true);
    model=new SingleRecordDataModel(columnHeaders,columnClasses);

    init();
  }

  private void init()
  {
    JPanel tablePanel=new JPanel(new GridLayout(1,1));
    JTable table=new JTable(model);
    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    JScrollPane tableView=new JScrollPane(table);
    tableView.setPreferredSize(new Dimension(300,150));
    tablePanel.add(tableView);
    tablePanel.setBorder(BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("new_record")));

    JPanel buttonPanel=new JPanel(new GridLayout(1,2));
    JButton ok=new JButton(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("ok"));
    ok.addActionListener(this);
    ok.setMnemonic('O');
    buttonPanel.add(ok);
    JButton cancel=new JButton(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("cancel"));
    cancel.setActionCommand(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("cancel"));
    cancel.addActionListener(this);
    cancel.setMnemonic('A');
    buttonPanel.add(cancel);
    JPanel outer=new JPanel(new FlowLayout(FlowLayout.CENTER));
    outer.add(buttonPanel);

    JPanel all=new JPanel(new BorderLayout(5,5));
    all.add(tablePanel,BorderLayout.CENTER);
    all.add(outer,BorderLayout.SOUTH);

    setContentPane(all);

    pack();

    //calculate coords
    Container parent=getParent();
    if(parent!=null)
    {
      setLocationRelativeTo(parent);
    }
    setVisible(true);
  }

  public void actionPerformed(ActionEvent event)
  {
    properlyClosed=event.getActionCommand().equalsIgnoreCase(java.util.ResourceBundle.getBundle("lindhorst/apps/jdbc/swing/i18n/modules").getString("ok"));
    setVisible(false);
  }

  public boolean isProperlyClosed()
  {
    return properlyClosed;
  }

  public Object[] getData()
  {
    return model.getData();
  }
} 
