/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */
package lindhorst.apps.jdbc.swing.modules.datamodels;

class ArraySorter
{
        public static int[] sortObjects(Object[] array)
        {
          int[] indices=prepareIndices(array.length);
          String[] strings=new String[array.length];
          for(int i=0;i<array.length;i++)
          {
            if(array[i]!=null)
                strings[i]=array[i].toString();
            else
                strings[i]="";
          }

          indices=doQuickSort(strings,indices,0,strings.length);

          return indices;
        }
        
        public static int[] sortStrings(String[] array) {
          int[] indices=prepareIndices(array.length);
          String[] strings=new String[array.length];
          for(int i=0;i<array.length;i++)
          {
            if(array[i]!=null)
                strings[i]=(String)array[i];
            else
                strings[i]="";
          }

          indices=doQuickSort(strings,indices,0,strings.length);

          return indices;
        }

        public static int[] sortNumbers(Number[] array)
        {
          int[] indices=prepareIndices(array.length);
          double[] doubles=new double[array.length];
          for(int i=0;i<array.length;i++)
          {
            if(array[i]!=null)
                doubles[i]=array[i].doubleValue();
            else
                doubles[i]=0.0;
          }

          indices=doQuickSort(doubles,indices,0,doubles.length);

          return indices;
        }

        public static int[] sortDates(java.util.Date[] array)
        {
          int[] indices=prepareIndices(array.length);
          long[] millis=new long[array.length];
          for(int i=0;i<array.length;i++)
          {
            if(array[i]!=null)
                millis[i]=array[i].getTime();
            else
                millis[i]=0L;
          }

          indices=doQuickSort(millis,indices,0,millis.length);

          return indices;
        }

        private static int[] prepareIndices(int  length)
        {
          int[] indices=new int[length];
          for(int i=0;i<length;i++)
                  indices[i]=i;
          return indices;
        }

        private static int[] doQuickSort(String[] toSort,int[] indices, int start, int length)
        {
          if(length<=1)
                return indices;

          int median=start+length/2;

          String temp=null;
          int index=0;
          //smaller elements to left
          int highOut=start+length;
          for(int i=median+1;i<highOut;i++)
          {
            if(toSort[i].compareTo(toSort[median])<0)
            {
              temp=toSort[i];
              System.arraycopy(toSort,start,toSort,start+1,i-start);
              toSort[start]=temp;
              index=indices[i];
              System.arraycopy(indices,start,indices,start+1,i-start);
              indices[start]=index;
              median++;
            }
          }

          //larger Elements to right
          for(int i=start;i<median;i++)
          {
            if(toSort[i].compareTo(toSort[median])>0)
            {
              temp=toSort[i];
              System.arraycopy(toSort,i+1,toSort,i,start+length-1-i);
              toSort[start+length-1]=temp;
              index=indices[i];
              System.arraycopy(indices,i+1,indices,i,start+length-1-i);
              indices[start+length-1]=index;
              median--;
              i--; //elements were shifted downwards
            }
          }

          //execute recursively
          doQuickSort(toSort,indices,start,median-start);
          doQuickSort(toSort,indices,median+1,length-(median+1-start));
          return indices;
        }

        private static int[] doQuickSort(double[] toSort,int[] indices, int start,int length)
        {
          if(length<=1)
                return indices;

          int median=start+length/2;

          double temp=0.0;
          int index=0;
          //smaller elements to left
          int highOut=start+length;
          for(int i=median+1;i<highOut;i++)
          {
            if(toSort[i]<toSort[median])
            {
              temp=toSort[i];
              System.arraycopy(toSort,start,toSort,start+1,i-start);
              toSort[start]=temp;
              index=indices[i];
              System.arraycopy(indices,start,indices,start+1,i-start);
              indices[start]=index;
              median++;
            }
          }

          //larger Elements to right
          for(int i=start;i<median;i++)
          {
            if(toSort[i]>toSort[median])
            {
              temp=toSort[i];
              System.arraycopy(toSort,i+1,toSort,i,start+length-1-i);
              toSort[start+length-1]=temp;
              index=indices[i];
              System.arraycopy(indices,i+1,indices,i,start+length-1-i);
              indices[start+length-1]=index;
              median--;
              i--; //elements were shifted downwards
            }
          }

          //execute recursively
          doQuickSort(toSort,indices,start,median-start);
          doQuickSort(toSort,indices,median+1,length-(median+1-start));
          return indices;
        }

        private static int[] doQuickSort(long[] toSort,int[] indices,int start,int length)
        {
          if(length<=1)
                return indices;

          int median=start+length/2;

          long temp=0L;
          int index=0;
          //smaller elements to left
          int highOut=start+length;
          for(int i=median+1;i<highOut;i++)
          {
            if(toSort[i]<toSort[median])
            {
              temp=toSort[i];
              System.arraycopy(toSort,start,toSort,start+1,i-start);
              toSort[start]=temp;
              index=indices[i];
              System.arraycopy(indices,start,indices,start+1,i-start);
              indices[start]=index;
              median++;
            }
          }

          //larger Elements to right
          for(int i=start;i<median;i++)
          {
            if(toSort[i]>toSort[median])
            {
              temp=toSort[i];
              System.arraycopy(toSort,i+1,toSort,i,start+length-1-i);
              toSort[start+length-1]=temp;
              index=indices[i];
              System.arraycopy(indices,i+1,indices,i,start+length-1-i);
              indices[start+length-1]=index;
              median--;
              i--; //elements were shifted downwards
            }
          }

          //execute recursively
          doQuickSort(toSort,indices,start,median-start);
          doQuickSort(toSort,indices,median+1,length-(median+1-start));
          return indices;
      }

      static int[] invert(int[] indices)
      {
        int[] neu=new int[indices.length];

        for(int i=0;i<indices.length;i++)
                neu[i]=indices[indices.length-i-1];

        return neu;
      }

}