/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */


package lindhorst.apps.jdbc.swing.modules.datamodels;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.sql.*;
import java.util.*;
import lindhorst.apps.jdbc.swing.*;
import lindhorst.apps.jdbc.swing.helpers.*;

public class SingleRecordDataModel implements TableModel
{
  private Object[] data=null;
  private String[] headers=null;
  private Class[] classes=null;
  private EventListenerList listeners=new EventListenerList();

  public SingleRecordDataModel(String[] headers)
  {
    this(headers,null);
  }

  public SingleRecordDataModel(String[] headers,Class[] columnClasses)
  {
    this.headers=headers;
    data=new Object[headers.length];
    this.classes=columnClasses;
    fireEntireTableChanged();
  }

  public void addTableModelListener(TableModelListener listener)
  {
    listeners.add(TableModelListener.class,listener);
    listener.tableChanged(new TableModelEvent(this,TableModelEvent.HEADER_ROW,0,TableModelEvent.ALL_COLUMNS,TableModelEvent.UPDATE));
  }

  public void removeTableModelListener(TableModelListener listener)
  {
    listeners.remove(TableModelListener.class,listener);
  }

  private void fireTableChanged(TableModelEvent event)
  {
    EventListener[] array=listeners.getListeners(TableModelListener.class);
    for(int i=0;i<array.length;i++) {
      ((TableModelListener)array[i]).tableChanged(event);
    }
  }

  private void fireEntireTableChanged()
  {
    fireTableChanged(new TableModelEvent(this,TableModelEvent.HEADER_ROW,0,TableModelEvent.ALL_COLUMNS,TableModelEvent.UPDATE));
  }

  public Class getColumnClass(int index)
  {
    if(classes==null || index>=classes.length) return String.class;
    else return classes[index];
  }

  public int getColumnCount()
  {
    return headers.length;
  }

  public String getColumnName(int index)
  {
    return headers[index];
  }

  public int getRowCount()
  {
    return 1;
  }

  public Object getValueAt(int rowIndex,int columnIndex)
  {
    return data[columnIndex];
  }

  public boolean isCellEditable(int row, int column)
  {
    return true;
  }

  public void setValueAt(Object value, int row, int column)
  {
    if(classes!=null && classes.length>column)
    {
      if(value instanceof String && classes[column].getSuperclass()==Number.class)
      {
        value=Helpers.convertToNumber((String)value,classes[column]);
      }
      if(value instanceof String && classes[column]==java.util.Date.class)
        value=Helpers.convertToDate((String)value,Locale.getDefault());
    }
    if(row!=0) return;

    if(column>=headers.length) return;

    data[column]=value;
    fireTableChanged(new TableModelEvent(this,0,0,column,TableModelEvent.UPDATE));
  }

  public Object[] getData()
  {
    return data;
  }
}