/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */
package lindhorst.swing.filechooser;

import javax.swing.filechooser.*;
import java.io.*;

public class ExtensionFileFilter extends javax.swing.filechooser.FileFilter
{
  private String description=null;
  private String[] extensions=null;

  public void setDescription(String description)
  {
    this.description=description;
  }

  public String getDescription()
  {
    return description;
  }

  public void addExtension(String extension)
  {
    int anzahl=0;
    if(extensions!=null) anzahl=extensions.length;
    anzahl++;
    String[] old=extensions;
    extensions=new String[anzahl];
    if(old!=null)
      System.arraycopy(old,0,extensions,0,old.length);
    extensions[anzahl-1]=extension;
  }

  public void setExtensions(String[] extensions)
  {
    this.extensions=extensions;
  }

  public String[] getExtensions()
  {
    return extensions;
  }

  public boolean accept(File file)
  {
    if(file.isDirectory()) return true;

    String name=file.getPath().toLowerCase();
    boolean ok=false;

    for(int i=0;i<extensions.length;i++)
    {
      ok=name.endsWith(extensions[i].toLowerCase());
      if(ok) break;
    }

    return ok;
  }

}
