/* 
 * This is JavaSQL, a tool to check the validity of connections and queries
 * in JDBC.
 * Copyright (C) 2002 Alexander Lindhorst
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact:
 * Alexander Lindhorst
 * Elsa-Brandstrm-Weg 3
 * 33102 Paderborn
 * Germany
 * al@alexander-lindhorst.de
 */
package lindhorst.swing.menu;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.*;

/*
 *
 * PicMenuBar
 *
 */
public class PLaFMenu extends JMenu {
    static {
        String windowsLook="com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        String macLook="com.sun.java.swing.plaf.mac.MacLookAndFeel";
        String kunststoff="com.incors.plaf.kunststoff.KunststoffLookAndFeel";
        boolean hasWindows=false,hasMac=false,hasPlastic=false;
        
        //installiert "eingeschrnkte Look & Feels"
        UIManager.LookAndFeelInfo[] lfs=UIManager.getInstalledLookAndFeels();
        for(int i=0;i<lfs.length;i++) {
            if(lfs[i].getClassName().equals(windowsLook))
                hasWindows=true;
            if(lfs[i].getClassName().equals(macLook))
                hasMac=true;
            if(lfs[i].getClassName().equals(kunststoff))
                hasPlastic=true;
        }
        
        try {
            if(!hasWindows)
                UIManager.installLookAndFeel("Windows",windowsLook);
            if(!hasMac)
                UIManager.installLookAndFeel("Macintosh",macLook);
            if(!hasPlastic)
                UIManager.installLookAndFeel("Kunststoff",kunststoff);
        }
        catch(Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
    
    private int anzahl;
    private UIManager.LookAndFeelInfo[] lf;
    ViewSwitcher switcher=null;
    
    public PLaFMenu() {
        super("Look&Feel");
        setMnemonic('L');
        
        lf=UIManager.getInstalledLookAndFeels();
        anzahl=lf.length;
        
        for(int i=0;i<anzahl;i++) {
            try {
                Class.forName(lf[i].getClassName());
            }
            catch(ClassNotFoundException exception) {
                System.err.println("No such class: "+lf[i].getClassName()+" - Look & Feel removed from Menu");
                continue;
            }
            ImageIcon icon=null;
            if(lf[i].getName().equalsIgnoreCase("Metal")) icon=getImageResource("javaicon.gif");
            if(lf[i].getName().equalsIgnoreCase("CDE/Motif")) icon=getImageResource("motificon.gif");
            if(lf[i].getName().equalsIgnoreCase("Windows")) icon=getImageResource("winicon.gif");
            if(lf[i].getName().equalsIgnoreCase("Kunststoff")) icon=getImageResource("plasticicon.gif");
            
            JMenuItem item;
            if(icon!=null) item=new JMenuItem(lf[i].getName(),icon);
            else item=new JMenuItem(lf[i].getName());
            
            item.setMnemonic(lf[i].getName().charAt(0));
            
            add(item);
        }
        
    }
    public PLaFMenu(Component target) {
        this();
        setTarget(target);
    }
    
    public void setTarget(Component target) {
        switcher=new ViewSwitcher(target,this);
    }
    
    public void addActionListener(ActionListener listener) {
        if(getMenuComponentCount()==0) return;
        
        
        for(int i=0;i<getMenuComponentCount();i++)
            ((JMenuItem)getMenuComponent(i)).addActionListener(listener);
    }
    
    public int getLookAndFeelCount() {
        return anzahl;
    }
    
    public boolean isEmpty() {
        return anzahl==0;
    }
    
    public UIManager.LookAndFeelInfo[] getItems() {
        return lf;
    }
    
    
    private ImageIcon getImageResource(String filename) {
        ImageIcon icon=null;
        
        try {
            InputStream io=getClass().getResourceAsStream(filename);
            ByteArrayOutputStream toBytes=new ByteArrayOutputStream(1100);
            int b;
            while( (b=io.read())!=-1)
                toBytes.write(b);
            byte[] daten=toBytes.toByteArray();
            icon=new ImageIcon(daten);
            return icon;
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
        
        return new ImageIcon(getClass().getResource(filename));
    }
    
    
    //Menu --> ZielElement
    static class ViewSwitcher implements ActionListener {
        private PLaFMenu menu;
        private Component target;
        private UIManager.LookAndFeelInfo[] lf;
        
        ViewSwitcher(Component theTarget, PLaFMenu theMenu) {
            menu=theMenu;
            menu.addActionListener(this);
            target=theTarget;
            lf=menu.getItems();
        }
        
        public void actionPerformed(ActionEvent ae) {
            String command=ae.getActionCommand();
            for(int i=0;i<lf.length;i++) {
                if(command.equalsIgnoreCase(lf[i].getName())) {
                    String klasse=lf[i].getClassName();
                    
                    try {
                        UIManager.setLookAndFeel(klasse);
                        SwingUtilities.updateComponentTreeUI(target);
                        //updateLnF(target);
                    }
                    catch(Exception e) {
                        JOptionPane.showMessageDialog(null,e.getMessage(),e.getClass().toString(),JOptionPane.ERROR_MESSAGE);
                    }
                    
                    break;
                }
                
                target.repaint(0L);
                target.validate();
            }
        }
        
    }
}

