/*
 * Decompiled with CFR 0.152.
 */
package lindhorst.servlet.http;

import java.io.IOException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReadableMultipartBlock {
    private byte[] rawData = null;
    private String compoundString = null;
    private String boundary = null;
    private String contentType = null;
    private String contentDisposition = null;
    private String name = null;
    private String value = null;
    private String fileName = null;
    private byte[] fileContent = null;
    private int index = 0;

    public ReadableMultipartBlock(byte[] byArray) throws IOException {
        this.rawData = byArray;
        this.decodeRawData();
        this.compoundString = new String(byArray);
    }

    public boolean isUploadedContent() {
        return this.contentType != null;
    }

    public boolean isNormalParameter() {
        return this.contentType == null;
    }

    public String getParameterName() {
        return this.name;
    }

    public String getParameterValue() throws IllegalAccessException {
        if (this.isUploadedContent()) {
            throw new IllegalAccessException("Multipart block holds uploaded content!");
        }
        return this.value;
    }

    public String getContentType() throws IllegalAccessException {
        if (this.isNormalParameter()) {
            throw new IllegalAccessException("Multipart block does not hold any uploaded content!");
        }
        return this.contentType;
    }

    public String getContentName() throws IllegalAccessException {
        if (this.isNormalParameter()) {
            throw new IllegalAccessException("Multipart block does not hold any uploaded content!");
        }
        return this.fileName;
    }

    public byte[] getContentData() throws IllegalAccessException {
        if (this.isNormalParameter()) {
            throw new IllegalAccessException("Multipart block does not hold any uploaded content!");
        }
        return this.fileContent;
    }

    public String getBlockAsString() {
        return this.compoundString;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    private void decodeRawData() throws IOException {
        boolean bl;
        this.index = 0;
        this.boundary = this.readLineAsString();
        String string = this.readLineAsString();
        this.contentDisposition = ReadableMultipartBlock.extractContentDisposition((String)string);
        this.name = ReadableMultipartBlock.extractName((String)string);
        this.fileName = ReadableMultipartBlock.extractFileName((String)string);
        String string2 = this.readLineAsString();
        boolean bl2 = bl = string2 != null && string2.length() > 0;
        if (bl) {
            this.contentType = ReadableMultipartBlock.extractContentType((String)string2);
        }
        String string3 = this.readLineAsString();
        if (bl) {
            if (string3 != null && string3.length() > 0) {
                throw new IOException("Malformed multipart information unit!");
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(this.rawData.length);
            String string4 = "\r\n";
            boolean bl3 = true;
            do {
                if (!bl3) {
                    stringBuffer.append(string4);
                }
                stringBuffer.append(string3);
                bl3 = false;
            } while ((string3 = this.readLineAsString()) != null);
            if (stringBuffer.length() > 0) {
                this.value = stringBuffer.toString();
            }
        }
        if (bl) {
            this.fileContent = this.readLastLineAsByteArray();
        }
    }

    private String readLineAsString() {
        byte[] byArray = this.readLineAsByteArray();
        if (byArray == null) {
            return null;
        }
        return new String(byArray, 0, byArray.length);
    }

    private byte[] readLineAsByteArray() {
        if (this.index >= this.rawData.length) {
            return null;
        }
        byte by = 13;
        byte by2 = 10;
        int n = this.index;
        while (this.index < this.rawData.length) {
            if (this.rawData[this.index] == by2 && this.index >= 1 && this.rawData[this.index - 1] == by) break;
            ++this.index;
        }
        byte[] byArray = new byte[this.index - n - 1];
        System.arraycopy(this.rawData, n, byArray, 0, byArray.length);
        ++this.index;
        return byArray;
    }

    private byte[] readLastLineAsByteArray() {
        int n = this.rawData.length;
        byte[] byArray = n - this.index >= 2 && this.rawData[n - 1] == 10 && this.rawData[n - 2] == 13 ? new byte[n - this.index - 2] : new byte[n - this.index];
        System.arraycopy(this.rawData, this.index, byArray, 0, byArray.length);
        return byArray;
    }

    private static String extractContentDisposition(String string) throws IOException {
        if (!string.toLowerCase().startsWith("content-disposition:")) {
            throw new IOException("Malformed multipart information unit!");
        }
        int n = string.indexOf(" ");
        int n2 = string.indexOf(";");
        if (n == -1 || n2 == -1) {
            throw new IOException("Malformed multipart information unit!");
        }
        return string.substring(n + 1, n2);
    }

    private static String extractName(String string) throws IOException {
        int n = string.indexOf("; ");
        if (n == -1) {
            throw new IOException("Malformed multipart information unit!");
        }
        if (!(string = string.substring(n + 2, string.length())).toLowerCase().startsWith("name=\"")) {
            throw new IOException("Malformed multipart information unit!");
        }
        n = 6;
        int n2 = string.indexOf("\";");
        if (n2 == -1) {
            n2 = string.length() - 1;
        }
        return string.substring(n, n2);
    }

    private static String extractFileName(String string) throws IOException {
        int n = string.indexOf("; ");
        if (n == -1) {
            throw new IOException("Malformed multipart information unit!");
        }
        if (!(string = string.substring(n + 2, string.length())).toLowerCase().startsWith("name=\"")) {
            throw new IOException("Malformed multipart information unit!");
        }
        n = string.indexOf("\"; ");
        if (n == -1) {
            return null;
        }
        string = string.substring(n += 3);
        n = 10;
        int n2 = string.length() - 1;
        if ((string = string.substring(n, string.length() - 1)).equals("")) {
            return null;
        }
        return string;
    }

    private static String extractContentType(String string) throws IOException {
        if (!string.toLowerCase().startsWith("content-type: ")) {
            throw new IOException("Malformed content type in multipart information unit!");
        }
        int n = 14;
        int n2 = string.length();
        return string.substring(n, n2);
    }
}

