/* 		    GNU GENERAL PUBLIC LICENSE
 * 		       Version 2, June 1991
 * 
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                        59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 * 
 * 			    Preamble
 * 
 *   The licenses for most software are designed to take away your
 * freedom to share and change it.  By contrast, the GNU General Public
 * License is intended to guarantee your freedom to share and change free
 * software--to make sure the software is free for all its users.  This
 * General Public License applies to most of the Free Software
 * Foundation's software and to any other program whose authors commit to
 * using it.  (Some other Free Software Foundation software is covered by
 * the GNU Library General Public License instead.)  You can apply it to
 * your programs, too.
 * 
 *   When we speak of free software, we are referring to freedom, not
 * price.  Our General Public Licenses are designed to make sure that you
 * have the freedom to distribute copies of free software (and charge for
 * this service if you wish), that you receive source code or can get it
 * if you want it, that you can change the software or use pieces of it
 * in new free programs; and that you know you can do these things.
 * 
 *   To protect your rights, we need to make restrictions that forbid
 * anyone to deny you these rights or to ask you to surrender the rights.
 * These restrictions translate to certain responsibilities for you if you
 * distribute copies of the software, or if you modify it.
 * 
 *   For example, if you distribute copies of such a program, whether
 * gratis or for a fee, you must give the recipients all the rights that
 * you have.  You must make sure that they, too, receive or can get the
 * source code.  And you must show them these terms so they know their
 * rights.
 * 
 *   We protect your rights with two steps: (1) copyright the software, and
 * (2) offer you this license which gives you legal permission to copy,
 * distribute and/or modify the software.
 * 
 *   Also, for each author's protection and ours, we want to make certain
 * that everyone understands that there is no warranty for this free
 * software.  If the software is modified by someone else and passed on, we
 * want its recipients to know that what they have is not the original, so
 * that any problems introduced by others will not reflect on the original
 * authors' reputations.
 * 
 *   Finally, any free program is threatened constantly by software
 * patents.  We wish to avoid the danger that redistributors of a free
 * program will individually obtain patent licenses, in effect making the
 * program proprietary.  To prevent this, we have made it clear that any
 * patent must be licensed for everyone's free use or not licensed at all.
 * 
 *   The precise terms and conditions for copying, distribution and
 * modification follow.
 * 
 * 		    GNU GENERAL PUBLIC LICENSE
 *    TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
 * 
 *   0. This License applies to any program or other work which contains
 * a notice placed by the copyright holder saying it may be distributed
 * under the terms of this General Public License.  The "Program", below,
 * refers to any such program or work, and a "work based on the Program"
 * means either the Program or any derivative work under copyright law:
 * that is to say, a work containing the Program or a portion of it,
 * either verbatim or with modifications and/or translated into another
 * language.  (Hereinafter, translation is included without limitation in
 * the term "modification".)  Each licensee is addressed as "you".
 * 
 * Activities other than copying, distribution and modification are not
 * covered by this License; they are outside its scope.  The act of
 * running the Program is not restricted, and the output from the Program
 * is covered only if its contents constitute a work based on the
 * Program (independent of having been made by running the Program).
 * Whether that is true depends on what the Program does.
 * 
 *   1. You may copy and distribute verbatim copies of the Program's
 * source code as you receive it, in any medium, provided that you
 * conspicuously and appropriately publish on each copy an appropriate
 * copyright notice and disclaimer of warranty; keep intact all the
 * notices that refer to this License and to the absence of any warranty;
 * and give any other recipients of the Program a copy of this License
 * along with the Program.
 * 
 * You may charge a fee for the physical act of transferring a copy, and
 * you may at your option offer warranty protection in exchange for a fee.
 * 
 *   2. You may modify your copy or copies of the Program or any portion
 * of it, thus forming a work based on the Program, and copy and
 * distribute such modifications or work under the terms of Section 1
 * above, provided that you also meet all of these conditions:
 * 
 *     a) You must cause the modified files to carry prominent notices
 *     stating that you changed the files and the date of any change.
 * 
 *     b) You must cause any work that you distribute or publish, that in
 *     whole or in part contains or is derived from the Program or any
 *     part thereof, to be licensed as a whole at no charge to all third
 *     parties under the terms of this License.
 * 
 *     c) If the modified program normally reads commands interactively
 *     when run, you must cause it, when started running for such
 *     interactive use in the most ordinary way, to print or display an
 *     announcement including an appropriate copyright notice and a
 *     notice that there is no warranty (or else, saying that you provide
 *     a warranty) and that users may redistribute the program under
 *     these conditions, and telling the user how to view a copy of this
 *     License.  (Exception: if the Program itself is interactive but
 *     does not normally print such an announcement, your work based on
 *     the Program is not required to print an announcement.)
 * 
 * These requirements apply to the modified work as a whole.  If
 * identifiable sections of that work are not derived from the Program,
 * and can be reasonably considered independent and separate works in
 * themselves, then this License, and its terms, do not apply to those
 * sections when you distribute them as separate works.  But when you
 * distribute the same sections as part of a whole which is a work based
 * on the Program, the distribution of the whole must be on the terms of
 * this License, whose permissions for other licensees extend to the
 * entire whole, and thus to each and every part regardless of who wrote it.
 * 
 * Thus, it is not the intent of this section to claim rights or contest
 * your rights to work written entirely by you; rather, the intent is to
 * exercise the right to control the distribution of derivative or
 * collective works based on the Program.
 * 
 * In addition, mere aggregation of another work not based on the Program
 * with the Program (or with a work based on the Program) on a volume of
 * a storage or distribution medium does not bring the other work under
 * the scope of this License.
 * 
 *   3. You may copy and distribute the Program (or a work based on it,
 * under Section 2) in object code or executable form under the terms of
 * Sections 1 and 2 above provided that you also do one of the following:
 * 
 *     a) Accompany it with the complete corresponding machine-readable
 *     source code, which must be distributed under the terms of Sections
 *     1 and 2 above on a medium customarily used for software interchange; or,
 * 
 *     b) Accompany it with a written offer, valid for at least three
 *     years, to give any third party, for a charge no more than your
 *     cost of physically performing source distribution, a complete
 *     machine-readable copy of the corresponding source code, to be
 *     distributed under the terms of Sections 1 and 2 above on a medium
 *     customarily used for software interchange; or,
 * 
 *     c) Accompany it with the information you received as to the offer
 *     to distribute corresponding source code.  (This alternative is
 *     allowed only for noncommercial distribution and only if you
 *     received the program in object code or executable form with such
 *     an offer, in accord with Subsection b above.)
 * 
 * The source code for a work means the preferred form of the work for
 * making modifications to it.  For an executable work, complete source
 * code means all the source code for all modules it contains, plus any
 * associated interface definition files, plus the scripts used to
 * control compilation and installation of the executable.  However, as a
 * special exception, the source code distributed need not include
 * anything that is normally distributed (in either source or binary
 * form) with the major components (compiler, kernel, and so on) of the
 * operating system on which the executable runs, unless that component
 * itself accompanies the executable.
 * 
 * If distribution of executable or object code is made by offering
 * access to copy from a designated place, then offering equivalent
 * access to copy the source code from the same place counts as
 * distribution of the source code, even though third parties are not
 * compelled to copy the source along with the object code.
 * 
 *   4. You may not copy, modify, sublicense, or distribute the Program
 * except as expressly provided under this License.  Any attempt
 * otherwise to copy, modify, sublicense or distribute the Program is
 * void, and will automatically terminate your rights under this License.
 * However, parties who have received copies, or rights, from you under
 * this License will not have their licenses terminated so long as such
 * parties remain in full compliance.
 * 
 *   5. You are not required to accept this License, since you have not
 * signed it.  However, nothing else grants you permission to modify or
 * distribute the Program or its derivative works.  These actions are
 * prohibited by law if you do not accept this License.  Therefore, by
 * modifying or distributing the Program (or any work based on the
 * Program), you indicate your acceptance of this License to do so, and
 * all its terms and conditions for copying, distributing or modifying
 * the Program or works based on it.
 * 
 *   6. Each time you redistribute the Program (or any work based on the
 * Program), the recipient automatically receives a license from the
 * original licensor to copy, distribute or modify the Program subject to
 * these terms and conditions.  You may not impose any further
 * restrictions on the recipients' exercise of the rights granted herein.
 * You are not responsible for enforcing compliance by third parties to
 * this License.
 * 
 *   7. If, as a consequence of a court judgment or allegation of patent
 * infringement or for any other reason (not limited to patent issues),
 * conditions are imposed on you (whether by court order, agreement or
 * otherwise) that contradict the conditions of this License, they do not
 * excuse you from the conditions of this License.  If you cannot
 * distribute so as to satisfy simultaneously your obligations under this
 * License and any other pertinent obligations, then as a consequence you
 * may not distribute the Program at all.  For example, if a patent
 * license would not permit royalty-free redistribution of the Program by
 * all those who receive copies directly or indirectly through you, then
 * the only way you could satisfy both it and this License would be to
 * refrain entirely from distribution of the Program.
 * 
 * If any portion of this section is held invalid or unenforceable under
 * any particular circumstance, the balance of the section is intended to
 * apply and the section as a whole is intended to apply in other
 * circumstances.
 * 
 * It is not the purpose of this section to induce you to infringe any
 * patents or other property right claims or to contest validity of any
 * such claims; this section has the sole purpose of protecting the
 * integrity of the free software distribution system, which is
 * implemented by public license practices.  Many people have made
 * generous contributions to the wide range of software distributed
 * through that system in reliance on consistent application of that
 * system; it is up to the author/donor to decide if he or she is willing
 * to distribute software through any other system and a licensee cannot
 * impose that choice.
 * 
 * This section is intended to make thoroughly clear what is believed to
 * be a consequence of the rest of this License.
 * 
 *   8. If the distribution and/or use of the Program is restricted in
 * certain countries either by patents or by copyrighted interfaces, the
 * original copyright holder who places the Program under this License
 * may add an explicit geographical distribution limitation excluding
 * those countries, so that distribution is permitted only in or among
 * countries not thus excluded.  In such case, this License incorporates
 * the limitation as if written in the body of this License.
 * 
 *   9. The Free Software Foundation may publish revised and/or new versions
 * of the General Public License from time to time.  Such new versions will
 * be similar in spirit to the present version, but may differ in detail to
 * address new problems or concerns.
 * 
 * Each version is given a distinguishing version number.  If the Program
 * specifies a version number of this License which applies to it and "any
 * later version", you have the option of following the terms and conditions
 * either of that version or of any later version published by the Free
 * Software Foundation.  If the Program does not specify a version number of
 * this License, you may choose any version ever published by the Free Software
 * Foundation.
 * 
 *   10. If you wish to incorporate parts of the Program into other free
 * programs whose distribution conditions are different, write to the author
 * to ask for permission.  For software which is copyrighted by the Free
 * Software Foundation, write to the Free Software Foundation; we sometimes
 * make exceptions for this.  Our decision will be guided by the two goals
 * of preserving the free status of all derivatives of our free software and
 * of promoting the sharing and reuse of software generally.
 * 
 * 			    NO WARRANTY
 * 
 *   11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
 * FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 * OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 * PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
 * OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
 * TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 * PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 * REPAIR OR CORRECTION.
 * 
 *   12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
 * WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 * REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
 * INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
 * OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
 * TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 * YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
 * PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 * 
 * 		     END OF TERMS AND CONDITIONS
 * 
 * 	    How to Apply These Terms to Your New Programs
 * 
 *   If you develop a new program, and you want it to be of the greatest
 * possible use to the public, the best way to achieve this is to make it
 * free software which everyone can redistribute and change under these terms.
 * 
 *   To do so, attach the following notices to the program.  It is safest
 * to attach them to the start of each source file to most effectively
 * convey the exclusion of warranty; and each file should have at least
 * the "copyright" line and a pointer to where the full notice is found.
 * 
 *     <one line to give the program's name and a brief idea of what it does.>
 *     Copyright (C) <year>  <name of author>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * 
 * Also add information on how to contact you by electronic and paper mail.
 * 
 * If the program is interactive, make it output a short notice like this
 * when it starts in an interactive mode:
 * 
 *     Gnomovision version 69, Copyright (C) year name of author
 *     Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
 *     This is free software, and you are welcome to redistribute it
 *     under certain conditions; type `show c' for details.
 * 
 * The hypothetical commands `show w' and `show c' should show the appropriate
 * parts of the General Public License.  Of course, the commands you use may
 * be called something other than `show w' and `show c'; they could even be
 * mouse-clicks or menu items--whatever suits your program.
 * 
 * You should also get your employer (if you work as a programmer) or your
 * school, if any, to sign a "copyright disclaimer" for the program, if
 * necessary.  Here is a sample; alter the names:
 * 
 *   Yoyodyne, Inc., hereby disclaims all copyright interest in the program
 *   `Gnomovision' (which makes passes at compilers) written by James Hacker.
 * 
 *   <signature of Ty Coon>, 1 April 1989
 *   Ty Coon, President of Vice
 * 
 * This General Public License does not permit incorporating your program into
 * proprietary programs.  If your program is a subroutine library, you may
 * consider it more useful to permit linking proprietary applications with the
 * library.  If this is what you want to do, use the GNU Library General
 * Public License instead of this License.
 */
package lindhorst.servlet.http;

import java.io.*;

import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;


/**
 * Other than the normal HttpServletRequest class contained in Sun's Servlet
 * Development Kit, this class handles requests with content type
 * "multipart/form-data". However it does only partly implement RFC 1867,
 * since it cannot handle more than one file per parameter (no content type
 * "multipart/mixed" in parameters).
 * Since it implements interface HttpServletRequest it can be used instead of the normal
 * HttpServletRequest that server hands over to the service method of class HttpServlet.
 * <br>
 * Example:<br>
 * <pre>
 * public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
 * {
 *   if(req.getContentType().toLowerCase().equals("multipart/form-data"))
 *     req=new MultipartRequest(req);
 *
 *   //do something with it
 * }
 * </pre>
 * With these lines multipart/form-data requests can be handled just like normal ones.
 * The only difference is that parameters have to be tested if they hold content or
 * text and treat them accordingly. See methods isContentParameter() and isNormalParameter().
 */
public class MultipartRequest implements HttpServletRequest {
    /*Constants*/

    /**the default max size for a multipart request*/
    private static int MAX_SIZE = 16 * 1024 * 1024; //max 16 MB
    private HttpServletRequest request = null;

    /**the maximum allowed content length for this request*/
    private int maxSize = MAX_SIZE;

    /**the boundary (see RFC 1867)*/
    private String boundary = "";

    /**stores what has been recognized as a parameter*/
    private HashMap params = new HashMap(5);

    /**stores what has been recognized as a file*/
    private Hashtable files = new Hashtable(5);

    /**stores the raw data of this request*/
    private byte[] data;

    /** creates a new MultipartRequest instance from the given
     * HttpServletRequest with the default maximum allowed size.
     * @param request the original HttpServletRequest
     * @exception IOException if parts needed to process the request have not been included in it or maximum size has been exceeded
     */
    public MultipartRequest(HttpServletRequest request)
        throws IOException {
        this(request, MAX_SIZE);
    }

    /** creates a new MultipartRequest instance from the given
     * HttpServletRequest with the given maximum allowed size.
     * @param request the original HttpServletRequest
     * @param maximumSize the new maximum allowed size for content length
     * @exception IOException if parts needed to process the request have not been included in it or maximum size has been exceeded
     */
    public MultipartRequest(HttpServletRequest request, int maximumSize)
        throws IOException {
        this.request = request;
        maxSize = maximumSize;

        //check for sanity
        if ((request.getContentType() == null) ||
                !request.getContentType().toLowerCase().startsWith("multipart/form-data")) {
            throw new IllegalArgumentException(
                "Not a multipart request! Found Content Type " +
                request.getContentType());
        }

        if (request.getContentLength() > maxSize) {
            throw new IOException(
                "Detected Denial of Service Attack: Content length exceeds maximum allowed size!");
        }

        //find out about the boundary
        boundary = extractBoundary(request.getContentType());

        if ((boundary == null) || boundary.equals("")) {
            throw new IOException("No valid boundary supplied in the request!");
        }

        //inspect the raw data of the request
        MultipartInputStreamHandler in = new MultipartInputStreamHandler();
    }

    /*--- methods to access properties of this MultipartRequest ---*/

    /**
     *the boundary returned by this method is the boundary extracted from
     *the original request plus a leading "--"
     *@return the boundary string of this request
     */
    public String getBoundary() {
        return boundary;
    }

    /**
     * Returns a string containing the lone value of the specified
     * parameter, or null if the parameter does not exist. For example,
     * in an HTTP servlet this method would return the value of the
     * specified query string parameter. Servlet writers should use
     * this method only when they are sure that there is only one value
     * for the parameter.  If the parameter has (or could have)
     * multiple values, servlet writers should use
     * getParameterValues. If a multiple valued parameter name is
     * passed as an argument, the return value is implementation
     * dependent.
     * Note: This only works for parameters containing text-based information.
     *
     * @see #getParameterValues
     *
     * @param name the name of the parameter whose value is required.
     */
    public String getParameter(String parameterName) {
        String[] array = getParameterValues(parameterName);

        if ((array == null) || (array.length == 0)) {
            return null;
        } else {
            return array[0];
        }
    }

    /**
     * Returns the values of the specified parameter for the request as
     * an array of strings, or null if the named parameter does not
     * exist. For example, in an HTTP servlet this method would return
     * the values of the specified query string or posted form as an
     * array of strings.
     * Note: This only works for parameters containing text-based information.
     *
     * @param name the name of the parameter whose value is required.
     * @see javax.servlet.ServletRequest#getParameter
     */
    public String[] getParameterValues(String parameterName) {
        return (String[]) params.get(parameterName);
    }

    /**
     *@param parameterName the name of the parameter
     *@return an array of bytes representing the content uploaded by the request for this parameter, null if parameter is text-based
     */
    public byte[] getParameterContent(String parameterName) {
        UploadedContent cont = (UploadedContent) files.get(parameterName);

        if (cont == null) {
            return null;
        }

        return cont.getData();
    }

    /**
     *@param parameterName the name of the parameter
     *@return this parameters content type if it is uploaded content, null otherwise
     */
    public String getParameterContentType(String parameterName) {
        UploadedContent cont = (UploadedContent) files.get(parameterName);

        if (cont == null) {
            return null;
        }

        return cont.getContentType();
    }

    /**
     *@param parameterName the name of the parameter
     *@return the original file name of the parameter's content, null if the parameter holds text-based information
     */
    public String getParameterContentFileName(String parameterName) {
        UploadedContent cont = (UploadedContent) files.get(parameterName);

        if (cont == null) {
            return null;
        }

        return cont.getFileName();
    }

    /**
     *@param parameterName the name of the parameter
     *@return true if the named parameter holds text-based information, false otherwise
     */
    public boolean isNormalParameter(String parameterName) {
        return params.containsKey(parameterName);
    }

    /**
     *@param parameterName the name of the parameter
     *@return true if the named parameter holds uploaded content, false otherwise
     */
    public boolean isContentParameter(String parameterName) {
        return files.containsKey(parameterName);
    }

    /**
     * Returns the parameter names for this request as an enumeration
     * of strings, or an empty enumeration if there are no parameters
     * or the input stream is empty.  The input stream would be empty
     * if all the data had been read from the stream returned by the
     * method getInputStream.
     */
    public Enumeration getParameterNames() {
        Vector v = new Vector(params.size() + files.size());

        Iterator iterator = params.keySet().iterator();

        while (iterator.hasNext())
            v.addElement(iterator.next());

        Enumeration e = files.keys();

        while (e.hasMoreElements())
            v.addElement(e.nextElement());

        return v.elements();
    }

    /* --- other methods defined by interface HttpServletRequest ---*/

    /**
     * Gets the array of cookies found in this request.
     *
     * @return the array of cookies found in this request
     */
    public Cookie[] getCookies() {
        return request.getCookies();
    }

    /**
     * Gets the HTTP method (for example, GET, POST, PUT) with which
     * this request was made. Same as the CGI variable REQUEST_METHOD.
     *
     * @return the HTTP method with which this request was made
     */
    public String getMethod() {
        return request.getMethod();
    }

    /**
     * Gets, from the first line of the HTTP request, the part of this
     * request's URI that is to the left of any query string.
     * For example,
     *
     * <blockquote>
     * <table>
     * <tr align=left><th>First line of HTTP request<th>
     * <th>Return from <code>getRequestURI</code>
     * <tr><td>POST /some/path.html HTTP/1.1<td><td>/some/path.html
     * <tr><td>GET http://foo.bar/a.html HTTP/1.0
     * <td><td>http://foo.bar/a.html
     * <tr><td>HEAD /xyz?a=b HTTP/1.1<td><td>/xyz
     * </table>
     * </blockquote>
     *
     * <p>To reconstruct a URL with a URL scheme and host, use the
     * method javax.servlet.http.HttpUtils.getRequestURL, which returns
     * a StringBuffer.
     *
     * @return this request's URI
     * @see javax.servlet.http.HttpUtils#getRequestURL
     */
    public String getRequestURI() {
        return request.getRequestURI();
    }

    /**
     * Gets the part of this request's URI that refers to the servlet
     * being invoked. Analogous to the CGI variable SCRIPT_NAME.
     *
     * @return the servlet being invoked, as contained in this
     * request's URI
     */
    public String getServletPath() {
        return request.getServletPath();
    }

    /**
     * Gets any optional extra path information following the servlet
     * path of this request's URI, but immediately preceding its query
     * string. Same as the CGI variable PATH_INFO.
     *
     * @return the optional path information following the servlet
     * path, but before the query string, in this request's URI; null
     * if this request's URI contains no extra path information
     */
    public String getPathInfo() {
        return request.getPathInfo();
    }

    /**
     * Gets any optional extra path information following the servlet
     * path of this request's URI, but immediately preceding its query
     * string, and translates it to a real path.  Similar to the CGI
     * variable PATH_TRANSLATED
     *
     * @return extra path information translated to a real path or null
     * if no extra path information is in the request's URI
     */
    public String getPathTranslated() {
        return request.getPathTranslated();
    }

    /**
     * Gets any query string that is part of the HTTP request URI.
     * Same as the CGI variable QUERY_STRING.
     *
     * @return query string that is part of this request's URI, or null
     * if it contains no query string
     */
    public String getQueryString() {
        return request.getQueryString();
    }

    /**
     * Gets the name of the user making this request.  The user name is
     * set with HTTP authentication.  Whether the user name will
     * continue to be sent with each subsequent communication is
     * browser-dependent.  Same as the CGI variable REMOTE_USER.
     *
     * @return the name of the user making this request, or null if not
     * known.
     */
    public String getRemoteUser() {
        return request.getRemoteUser();
    }

    /**
     * Gets the authentication scheme of this request.  Same as the CGI
     * variable AUTH_TYPE.
     *
     * @return this request's authentication scheme, or null if none.
     */
    public String getAuthType() {
        return request.getAuthType();
    }

    /**
     * Gets the value of the requested header field of this request.
     * The case of the header field name is ignored.
     *
     * @param name the String containing the name of the requested
     * header field
     * @return the value of the requested header field, or null if not
     * known.
     */
    public String getHeader(String name) {
        return request.getHeader(name);
    }

    /**
     * Gets the value of the specified integer header field of this
     * request.  The case of the header field name is ignored.  If the
     * header can't be converted to an integer, the method throws a
     * NumberFormatException.
     *
     * @param name the String containing the name of the requested
     * header field
     * @return the value of the requested header field, or -1 if not
     * found.
     */
    public int getIntHeader(String name) {
        return request.getIntHeader(name);
    }

    /**
     * Gets the value of the requested date header field of this
     * request.  If the header can't be converted to a date, the method
     * throws an IllegalArgumentException.  The case of the header
     * field name is ignored.
     *
     * @param name the String containing the name of the requested
     * header field
     * @return the value the requested date header field, or -1 if not
     * found.
     */
    public long getDateHeader(String name) {
        return request.getDateHeader(name);
    }

    /**
     * Gets the header names for this request.
     *
     * @return an enumeration of strings representing the header names
     * for this request. Some server implementations do not allow
     * headers to be accessed in this way, in which case this method
     * will return null.
     */
    public Enumeration getHeaderNames() {
        return request.getHeaderNames();
    }

    /**
     * Gets the current valid session associated with this request, if
     * create is false or, if necessary, creates a new session for the
     * request, if create is true.
     *
     * <p><b>Note</b>: to ensure the session is properly maintained,
     * the servlet developer must call this method (at least once)
     * before any output is written to the response.
     *
     * <p>Additionally, application-writers need to be aware that newly
     * created sessions (that is, sessions for which
     * <code>HttpSession.isNew</code> returns true) do not have any
     * application-specific state.
     *
     * @return the session associated with this request or null if
     * create was false and no valid session is associated
     * with this request.
     */
    public HttpSession getSession(boolean create) {
        return request.getSession(create);
    }

    public HttpSession getSession() {
        return request.getSession();
    }

    /**
     * Gets the session id specified with this request.  This may
     * differ from the actual session id.  For example, if the request
     * specified an id for an invalid session, then this will get a new
     * session with a new id.
     *
     * @return the session id specified by this request, or null if the
     * request did not specify a session id
     *
     * @see #isRequestedSessionIdValid */
    public String getRequestedSessionId() {
        return request.getRequestedSessionId();
    }

    /**
     * Checks whether this request is associated with a session that
     * is valid in the current session context.  If it is not valid,
     * the requested session will never be returned from the
     * <code>getSession</code> method.
     *
     * @return true if this request is assocated with a session that is
     * valid in the current session context.
     *
     * @see #getRequestedSessionId
     * @see javax.servlet.http.HttpSessionContext
     * @see #getSession
     */
    public boolean isRequestedSessionIdValid() {
        return request.isRequestedSessionIdValid();
    }

    /**
     * Checks whether the session id specified by this request came in
     * as a cookie.  (The requested session may not be one returned by
     * the <code>getSession</code> method.)
     *
     * @return true if the session id specified by this request came in
     * as a cookie; false otherwise
     *
     * @see #getSession
     */
    public boolean isRequestedSessionIdFromCookie() {
        return request.isRequestedSessionIdFromCookie();
    }

    /**
     * Checks whether the session id specified by this request came in
     * as part of the URL.  (The requested session may not be the one
     * returned by the <code>getSession</code> method.)
     *
     * @return true if the session id specified by the request for this
     * session came in as part of the URL; false otherwise
     *
     * @see #getSession
     */
    public boolean isRequestedSessionIdFromUrl() {
        return request.isRequestedSessionIdFromUrl();
    }

    /* -- methods defined by interface ServletRequest -- */

    /**
     * Returns the size of the request entity data, or -1 if not known.
     * Same as the CGI variable CONTENT_LENGTH.
     */
    public int getContentLength() {
        return request.getContentLength();
    }

    /**
     * Returns the Internet Media Type of the request entity data, or
     * null if not known. Same as the CGI variable CONTENT_TYPE.
     */
    public String getContentType() {
        return "multipart/form-data";
    }

    /**
     * Returns the protocol and version of the request as a string of
     * the form <code>&lt;protocol&gt;/&lt;major version&gt;.&lt;minor
     * version&gt</code>.  Same as the CGI variable SERVER_PROTOCOL.
     */
    public String getProtocol() {
        return request.getProtocol();
    }

    /**
     * Returns the scheme of the URL used in this request, for example
     * "http", "https", or "ftp".  Different schemes have different
     * rules for constructing URLs, as noted in RFC 1738.  The URL used
     * to create a request may be reconstructed using this scheme, the
     * server name and port, and additional information such as URIs.
     */
    public String getScheme() {
        return request.getScheme();
    }

    /**
     * Returns the host name of the server that received the request.
     * Same as the CGI variable SERVER_NAME.
     */
    public String getServerName() {
        return request.getServerName();
    }

    /**
     * Returns the port number on which this request was received.
     * Same as the CGI variable SERVER_PORT.
     */
    public int getServerPort() {
        return request.getServerPort();
    }

    /**
     * Returns the IP address of the agent that sent the request.
     * Same as the CGI variable REMOTE_ADDR.
     */
    public String getRemoteAddr() {
        return request.getRemoteAddr();
    }

    /**
     * Returns the fully qualified host name of the agent that sent the
     * request. Same as the CGI variable REMOTE_HOST.
     */
    public String getRemoteHost() {
        return request.getRemoteHost();
    }

    /**
     * Applies alias rules to the specified virtual path and returns
     * the corresponding real path, or null if the translation can not
     * be performed for any reason.  For example, an HTTP servlet would
     * resolve the path using the virtual docroot, if virtual hosting
     * is enabled, and with the default docroot otherwise.  Calling
     * this method with the string "/" as an argument returns the
     * document root.
     *
     * @param path the virtual path to be translated to a real path
     */
    public String getRealPath(String path) {
        return request.getRealPath(path);
    }

    /**
     * Returns an input stream for reading binary data in the request body.
     *
     * @see #getReader
     * @exception IllegalStateException if getReader has been
     *        called on this same request.
     * @exception IOException on other I/O related errors.
     */
    public ServletInputStream getInputStream() throws IOException {
        return request.getInputStream();
    }

    /**
     * Returns the value of the named attribute of the request, or
     * null if the attribute does not exist.  This method allows
     * access to request information not already provided by the other
     * methods in this interface.  Attribute names should follow the
     * same convention as package names.
     * The following predefined attributes are provided.
     *
     * <TABLE BORDER>
     * <tr>
     *        <th>Attribute Name</th>
     *        <th>Attribute Type</th>
     *        <th>Description</th>
     *        </tr>
     *
     * <tr>
     *        <td VALIGN=TOP>javax.net.ssl.cipher_suite</td>
     *        <td VALIGN=TOP>string</td>
     *        <td>The string name of the SSL cipher suite in use, if the
     *                request was made using SSL</td>
     *        </tr>
     *
     * <tr>
     *        <td VALIGN=TOP>javax.net.ssl.peer_certificates</td>
     *        <td VALIGN=TOP>array of javax.security.cert.X509Certificate</td>
     *        <td>The chain of X.509 certificates which authenticates the client.
     *                This is only available when SSL is used with client
     *                authentication is used.</td>
     *        </tr>
     *
     * <tr>
     *        <td VALIGN=TOP>javax.net.ssl.session</td>
     *        <td VALIGN=TOP>javax.net.ssl.SSLSession</td>
     *        <td>An SSL session object, if the request was made using SSL.</td>
     *        </tr>
     *
     * </TABLE>
     *
     * <BR>
     * <P>The package (and hence attribute) names beginning with java.*,
     * and javax.* are reserved for use by Javasoft. Similarly, com.sun.*
     * is reserved for use by Sun Microsystems.
     *
     * @param name the name of the attribute whose value is required
     */
    public Object getAttribute(String name) {
        return request.getAttribute(name);
    }

    /**
     * Returns a buffered reader for reading text in the request body.
     * This translates character set encodings as appropriate.
     *
     * @see #getInputStream
     *
     * @exception UnsupportedEncodingException if the character set encoding
     *  is unsupported, so the text can't be correctly decoded.
     * @exception IllegalStateException if getInputStream has been
     *        called on this same request.
     * @exception IOException on other I/O related errors.
     */
    public BufferedReader getReader() throws IOException {
        return request.getReader();
    }

    public boolean isRequestedSessionIdFromURL() {
        return request.isRequestedSessionIdFromURL();
    }

    /**
     * Returns the character set encoding for the input of this request.
     */
    public String getCharacterEncoding() {
        return request.getCharacterEncoding();
    }

    public String getContextPath() {
        return request.getContextPath();
    }

    public Enumeration getAttributeNames() {
        return request.getAttributeNames();
    }

    public Enumeration getHeaders(String name) {
        return request.getHeaders(name);
    }

    public Locale getLocale() {
        return request.getLocale();
    }

    public Enumeration getLocales() {
        return request.getLocales();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return request.getRequestDispatcher(path);
    }

    public StringBuffer getRequestURL() {
        return request.getRequestURL();
    }

    public boolean isSecure() {
        return request.isSecure();
    }

    public boolean isUserInRole(String role) {
        return request.isUserInRole(role);
    }

    public java.security.Principal getUserPrincipal() {
        return request.getUserPrincipal();
    }

    public Map getParameterMap() {
        return params;
    }

    public void setAttribute(String name, Object value) {
        request.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        request.removeAttribute(name);
    }

    public void setCharacterEncoding(String encoding)
        throws UnsupportedEncodingException {
        request.setCharacterEncoding(encoding);
    }

    public byte[] getRawData() {
        return data;
    }

    /*--- utility methods ---*/

    /**
     *extracts the boundary for this request from the given line
     *@param line the String object holding the boundary (content type line)
     *@return the boundary
     */
    private static String extractBoundary(String line) {
        int pos = line.indexOf("boundary");

        if (pos < 0) {
            return null;
        } else {
            return "--" + line.substring(pos + 9);
        }
    }

    private void insertParameterValue(String parameterName, String value) {
        if (isContentParameter(parameterName)) {
            throw new RuntimeException(
                "Content and String parameter cannot have the same name!");
        }

        String[] array = (String[]) params.get(parameterName);

        if (array == null) {
            array = new String[1];
        } else {
            String[] temp = new String[array.length + 1];
            System.arraycopy(array, 0, temp, 0, array.length);
            array = temp;
        }

        array[array.length - 1] = value;
        params.put(parameterName, array);
    }

    private class MultipartInputStreamHandler {
        private ServletInputStream stream = null;
        private int index = 0;
        private boolean done = false;

        MultipartInputStreamHandler() throws IOException {
            stream = request.getInputStream();

            //get raw data
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(request.getContentLength());

            int actByte;

            while ((actByte = stream.read()) != -1) {
                bOut.write(actByte);
            }

            data = bOut.toByteArray();

            evaluate();
        }

        private void evaluate() throws IOException {
            index = 0; //start at the beginning

            ReadableMultipartBlock block = null;
            UploadedContent content = null;

            while (!done) {
                block = new ReadableMultipartBlock(getNextBlock());

                try {
                    if (block.isUploadedContent()) {
                        content = new UploadedContent(block.getContentName(),
                                block.getContentType(), block.getContentData());

                        if ((content.getData() != null) &&
                                (content.getData().length > 0)) {
                            files.put(block.getParameterName(), content);
                        }
                    } else {
                        if (block.getParameterValue() != null) {
                            insertParameterValue(block.getParameterName(),
                                block.getParameterValue());
                        }
                    }
                } catch (IllegalAccessException iae) //should never be thrown due to questioning it before action
                 {
                    iae.printStackTrace();
                }
            }
        }

        private byte[] getNextBlock() throws IOException {
            //is the index valid?
            if (index >= data.length) {
                throw new IOException("Malformed multipart/form-data request!");
            }

            //first line is to match boundary
            byte[] line = readLine();
            String matchBound = new String(line, 0, line.length);

            if (!matchBound.startsWith(boundary)) {
                throw new IOException("Malformed multipart/form-data request!");
            }

            //else gather the data of this block
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024); //buffer it with 1K

            do {
                bout.write(line, 0, line.length);
                line = readLine();
            } while (!(matchBound = new String(line)).startsWith(boundary)); //last boundary not included

            //one line too far due to preview on next boundary, set index back
            index -= line.length;

            //are we done? (ends with -- after last boundary)
            if (matchBound.startsWith(boundary + "--")) {
                done = true;
            }

            return bout.toByteArray();
        }

        private byte[] readLine() {
            //reads the next line from the rawdata
            //start of line is indicated by index
            byte cr = (byte) '\r';
            byte ln = (byte) '\n';
            int start = index;

            while (index < data.length) {
                if ((data[index] == ln) && (index >= 1) &&
                        (data[index - 1] == cr)) {
                    break;
                }

                index++;
            }

            byte[] line = new byte[index - start + 1];
            System.arraycopy(data, start, line, 0, line.length);

            //have index point to next unread byte
            index++;

            return line;
        }
    }
}
